/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Unlimited Scan 2  (COMI-LX20x ø  A/D ĵ )
/* - Contents: 
/*    α׷ Unlimited Scan 2 õ Լ 뿹 ִ 
/*    Դϴ.  α׷   ϴ.
/*    1. A/D CH0 CH1 Ͽ Unlimited Scan 2 Ѵ. 
/*    2. 4096 Ͱ ȹǸ ƽŰ Ͽ Ѵ.
/*    3.  ÿ   ĵ   ϵ Ѵ.
/*
/* - Remarks : 
/*     1.   COMI-LX201 带 ϴ  ۼǾϴ.
/*      ٸ 带 ϴ 쿡 COMILX_LoadDevice(...)Լ 
/*     ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.   
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "ComidasLx.h"

#define DEV_ID	COMI_LX201 // Device ID 
#define NUM_CH	2		// Number of channels -> 2 Channels
#define S_FREQ	1000000	// Scan freq. -> 1 MHz 
#define BUF_SIZE_GAIN	1 

#define ESC_KEY	27 

void main (void)
{
	HANDLE hDevice;
	FILE *fp;
	int ch_list[2] = {0, 1};  /* Scan channel list : 0  1 ä */
	short *pScanBuf[NUM_CH];
	int count=0;

	/* Load DLL */
	if(!COMILX_LoadDll()){
		exit(0);
	}
	/* Load Device */
	hDevice = COMILX_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		COMILX_UnloadDll(); 
		exit(0);
	}

	printf("A/D Scan Ϸ ƹŰ ʽÿ.\n");
	printf("ʹ C:\\comius2.txt Ͽ ˴ϴ.\n");
	_getch();
	
	/* start unlimited scan */
	COMILX_US2_Start (hDevice, NUM_CH, ch_list, S_FREQ, BUF_SIZE_GAIN, TRUE);

	/* Create a file to save data */
	if((fp = fopen ("c:\\ComiUscan.txt", "w")) == NULL){
		printf("͸     ϴ.\nƹŰ  ˴ϴ.\n");
		_getch();
		COMILX_US1_Stop (hDevice, TRUE);
		COMILX_UnloadDevice(hDevice);
		COMILX_UnloadDll();
		exit(0);
	}
	fprintf (fp,"   CH0    CH1\n");
	
	while(1)
	{
		printf("..");
		if(COMILX_US2_IsBufFull(hDevice))
		{
			pScanBuf[0] = COMILX_US2_GetBuffer(hDevice, 0); // 0 ä ĵ  ͸ ´.
			pScanBuf[1] = COMILX_US2_GetBuffer(hDevice, 1); // 1 ä ĵ  ͸ ´.
			for(int i=0; i<BUF_SIZE_GAIN*4096; i++)
			{
				fprintf (fp, "%6d %6d\n", pScanBuf[0][i], pScanBuf[1][i]); // ĵ۷κ ͸ Ͽ Ͽ Ѵ. 
			}
			count++;
			printf("\näδ %d Ͱ Ǿϴ.\n"
				"ؼ ͸ Ͻ÷ EnterŰ, Ͻ÷ ESCŰ ԷϽʽÿ.\n",
				count*4096*BUF_SIZE_GAIN);
			if(_getch() == ESC_KEY)
				break;
			else
				COMILX_US2_Resume(hDevice);
		}
	}
	fclose(fp);
	COMILX_US2_Stop (hDevice, TRUE);
	COMILX_UnloadDevice(hDevice);
	COMILX_UnloadDll();
}
